/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IDistrictDAO;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.QDistrict;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QMunicipality;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.toolkit.misc.Log;

public abstract class DistrictDAOBase
implements IDistrictDAO {
    private static final Log logger = Log.getLogger(DistrictDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from District e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(District entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public District save(District entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (District)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public District findPersisted(District entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            District persisted = (District)this.em.find(District.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public District findById(String entityId) {
        return (District)this.em.find(District.class, (Object)entityId);
    }

    @Override
    public List<District> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDistrict.district})).list((Expression)QDistrict.district);
    }

    @Override
    public void loadDtcs(District entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String districtId) {
        if (districtId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.districtId.eq((Object)districtId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadMunicipalities(District entity) {
        if (entity != null && entity.getMunicipalities() == null) {
            entity.setMunicipalities(this.getMunicipalities(entity.getId()));
        }
    }

    @Override
    public Set<Municipality> getMunicipalities(String districtId) {
        if (districtId != null) {
            return new HashSet<Municipality>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QMunicipality.municipality})).where(new Predicate[]{QMunicipality.municipality.districtId.eq((Object)districtId)})).list((Expression)QMunicipality.municipality));
        }
        return new HashSet<Municipality>();
    }

    @Override
    public void loadTimers(District entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String districtId) {
        if (districtId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.districtId.eq((Object)districtId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }
}

