/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IControlDAO;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.QControl;
import pt.efacec.smartlighting.common.core.entity.QPeriod;
import pt.efacec.smartlighting.common.core.entity.QSpecialDayService;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class ControlDAOBase
implements IControlDAO {
    private static final Log logger = Log.getLogger(ControlDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Control e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Control entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Control save(Control entity) {
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Control)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Control findPersisted(Control entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Control persisted = (Control)this.em.find(Control.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Control findById(String entityId) {
        return (Control)this.em.find(Control.class, (Object)entityId);
    }

    @Override
    public List<Control> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QControl.control})).list((Expression)QControl.control);
    }

    @Override
    public void loadSpecialDayService(Control entity) {
        if (entity != null) {
            entity.setSpecialDayService(this.getSpecialDayService(entity.getSpecialDayServiceId()));
        }
    }

    @Override
    public SpecialDayService getSpecialDayService(String specialDayServiceId) {
        if (specialDayServiceId != null) {
            return (SpecialDayService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService})).where(new Predicate[]{QSpecialDayService.specialDayService.id.eq((Object)specialDayServiceId)})).uniqueResult((Expression)QSpecialDayService.specialDayService);
        }
        return null;
    }

    @Override
    public List<Control> findAllBySpecialDayService(String specialDayServiceId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QControl.control})).where(new Predicate[]{specialDayServiceId == null ? QControl.control.specialDayServiceId.isNull() : QControl.control.specialDayServiceId.eq((Object)specialDayServiceId)})).list((Expression)QControl.control);
    }

    @Override
    public void loadPeriod(Control entity) {
        if (entity != null) {
            entity.setPeriod(this.getPeriod(entity.getPeriodId()));
        }
    }

    @Override
    public Period getPeriod(String periodId) {
        if (periodId != null) {
            return (Period)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QPeriod.period})).where(new Predicate[]{QPeriod.period.id.eq((Object)periodId)})).uniqueResult((Expression)QPeriod.period);
        }
        return null;
    }

    @Override
    public List<Control> findAllByPeriod(String periodId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QControl.control})).where(new Predicate[]{periodId == null ? QControl.control.periodId.isNull() : QControl.control.periodId.eq((Object)periodId)})).list((Expression)QControl.control);
    }

    @Override
    public List<Control> findAllByPeriodOrderByOrder(String periodId) {
        try {
            return this.handleFindAllByPeriodOrderByOrder(periodId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findAllByPeriodOrderByOrder.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findAllByPeriodOrderByOrder.", e);
        }
    }

    protected abstract List<Control> handleFindAllByPeriodOrderByOrder(String var1);

    @Override
    public Long removeByPeriod(String periodId) {
        if (periodId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ControlDAO.removeByPeriod", "periodId"});
        }
        try {
            return this.handleRemoveByPeriod(periodId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing removeByPeriod.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing removeByPeriod.", e);
        }
    }

    protected abstract Long handleRemoveByPeriod(String var1);

    @Override
    public void removeBySpecialDayService(String specialDayServiceId) {
        if (specialDayServiceId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ControlDAO.removeBySpecialDayService", "specialDayServiceId"});
        }
        try {
            this.handleRemoveBySpecialDayService(specialDayServiceId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing removeBySpecialDayService.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing removeBySpecialDayService.", e);
        }
    }

    protected abstract void handleRemoveBySpecialDayService(String var1);
}

