/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IClientEntityDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ClientSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.QClientEntity;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ClientEntityDAOBase
implements IClientEntityDAO {
    private static final Log logger = Log.getLogger(ClientEntityDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from ClientEntity e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(ClientEntity entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public ClientEntity save(ClientEntity entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (ClientEntity)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public ClientEntity findPersisted(ClientEntity entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            ClientEntity persisted = (ClientEntity)this.em.find(ClientEntity.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public ClientEntity findById(String entityId) {
        return (ClientEntity)this.em.find(ClientEntity.class, (Object)entityId);
    }

    @Override
    public List<ClientEntity> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity})).list((Expression)QClientEntity.clientEntity);
    }

    @Override
    public void loadUsers(ClientEntity entity) {
        if (entity != null && entity.getUsers() == null) {
            entity.setUsers(this.getUsers(entity.getId()));
        }
    }

    @Override
    public Set<User> getUsers(String clientEntityId) {
        if (clientEntityId != null) {
            return new HashSet<User>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.clientId.eq((Object)clientEntityId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).list((Expression)QUser.user));
        }
        return new HashSet<User>();
    }

    @Override
    public void loadDtcs(ClientEntity entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String clientEntityId) {
        if (clientEntityId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.clientId.eq((Object)clientEntityId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadTimers(ClientEntity entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String clientEntityId) {
        if (clientEntityId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.clientId.eq((Object)clientEntityId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }

    @Override
    public Page<ClientEntity> search(ClientSearchDTO criteria, List<String> clientIds) {
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria, clientIds);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria, clientIds);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria, clientIds);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<ClientEntity> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(ClientSearchDTO criteria, List<String> clientIds) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity});
    }

    protected List<ClientEntity> queryForSearch(JPAQuery query) {
        return query.list((Expression)QClientEntity.clientEntity);
    }

    protected abstract SearchParam buildSearchSearchParam(ClientSearchDTO var1, List<String> var2);

    @Override
    public ClientEntity findByName(String name) {
        if (name == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ClientEntityDAO.findByName", "name"});
        }
        try {
            return this.handleFindByName(name);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findByName.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findByName.", e);
        }
    }

    protected abstract ClientEntity handleFindByName(String var1);
}

