/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.List;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.ClientEntityDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ClientSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.QClientEntity;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="clientEntity")
public class ClientEntityDAO
extends ClientEntityDAOBase {
    @Override
    public ClientEntity save(ClientEntity entity) {
        ClientEntity persisted;
        if (entity.getVersion() != null && !Tool.similar((Object)(persisted = this.findPersisted(entity)).getName(), (Object)entity.getName())) {
            JPASubQuery sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.clientId.eq((Object)entity.getId())});
            new JPAUpdateClause(this.em, (EntityPath)QEvent.event).set((Path)QEvent.event.clientName, (Object)entity.getName()).where(new Predicate[]{QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id))}).execute();
        }
        return super.save(entity);
    }

    @Override
    protected SearchParam buildSearchSearchParam(ClientSearchDTO criteria, List<String> clientIds) {
        SearchParam searchParam;
        block9: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            if (!Strings.isEmpty((String)criteria.getName())) {
                expression = QClientEntity.clientEntity.name.upper().like(criteria.getName().toUpperCase());
            }
            if (clientIds != null && !clientIds.isEmpty()) {
                expression = SLUtil.and(expression, QClientEntity.clientEntity.id.notIn(clientIds));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block9;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QClientEntity.clientEntity.name.asc() : QClientEntity.clientEntity.name.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected ClientEntity handleFindByName(String name) {
        return (ClientEntity)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity})).where(new Predicate[]{QClientEntity.clientEntity.name.toLowerCase().eq((Object)name.toLowerCase())})).uniqueResult((Expression)QClientEntity.clientEntity);
    }
}

