/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IAuditActionDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.AuditReportDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportSearchDTO;
import pt.efacec.smartlighting.common.core.entity.AuditAction;
import pt.efacec.smartlighting.common.core.entity.QAuditAction;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.dto.AuditLog;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class AuditActionDAOBase
implements IAuditActionDAO {
    private static final Log logger = Log.getLogger(AuditActionDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from AuditAction e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(AuditAction entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public AuditAction save(AuditAction entity) {
        String temp = null;
        temp = entity.getText();
        if (temp != null && temp.length() > 4000) {
            entity.setText(temp.substring(0, 4000));
        }
        if ((temp = entity.getLogin()) != null && temp.length() > 255) {
            entity.setLogin(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (AuditAction)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public AuditAction findPersisted(AuditAction entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            AuditAction persisted = (AuditAction)this.em.find(AuditAction.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public AuditAction findById(String entityId) {
        return (AuditAction)this.em.find(AuditAction.class, (Object)entityId);
    }

    @Override
    public List<AuditAction> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAuditAction.auditAction})).list((Expression)QAuditAction.auditAction);
    }

    @Override
    public void loadUser(AuditAction entity) {
        if (entity != null) {
            entity.setUser(this.getUser(entity.getUserId()));
        }
    }

    @Override
    public User getUser(String userId) {
        if (userId != null) {
            return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.id.eq((Object)userId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
        }
        return null;
    }

    @Override
    public List<AuditAction> findAllByUser(String userId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAuditAction.auditAction})).where(new Predicate[]{userId == null ? QAuditAction.auditAction.userId.isNull() : QAuditAction.auditAction.userId.eq((Object)userId)})).list((Expression)QAuditAction.auditAction);
    }

    @Override
    public void logAction(User user, AuditActionContextLOV context, AuditActionTypeLOV type, AuditLog log) {
        if (context == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"AuditActionDAO.logAction", "context"});
        }
        if (type == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"AuditActionDAO.logAction", "type"});
        }
        try {
            this.handleLogAction(user, context, type, log);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing logAction.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing logAction.", e);
        }
    }

    protected abstract void handleLogAction(User var1, AuditActionContextLOV var2, AuditActionTypeLOV var3, AuditLog var4);

    @Override
    public Page<AuditReportDTO> searchAudit(AuditReportSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"AuditActionDAO.searchAudit", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchAuditSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchAudit(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchAudit(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<AuditReportDTO> list = this.queryForSearchAudit(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchAudit.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchAudit.", e);
        }
    }

    protected JPAQuery createQueryForSearchAudit(AuditReportSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAuditAction.auditAction});
    }

    protected abstract List<AuditReportDTO> queryForSearchAudit(JPAQuery var1);

    protected abstract SearchParam buildSearchAuditSearchParam(AuditReportSearchDTO var1);
}

