/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.AuditActionDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.AuditReportDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportSearchDTO;
import pt.efacec.smartlighting.common.core.entity.AuditAction;
import pt.efacec.smartlighting.common.core.entity.QAuditAction;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.dto.AuditLog;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="auditActionDAO")
public class AuditActionDAO
extends AuditActionDAOBase {
    @Override
    protected void handleLogAction(User user, AuditActionContextLOV context, AuditActionTypeLOV type, AuditLog log) {
        AuditAction audit = new AuditAction();
        if (user != null) {
            audit.setUserId(user.getId());
            audit.setLogin(user.getLogin());
        }
        audit.setContext(context);
        audit.setType(type);
        if (log != null) {
            audit.setText(log.stringify());
        }
        audit.setDate(new Date());
        this.save(audit);
    }

    @Override
    protected List<AuditReportDTO> queryForSearchAudit(JPAQuery query) {
        List result = query.list((Expression)QAuditAction.auditAction);
        ArrayList<AuditReportDTO> dtos = new ArrayList<AuditReportDTO>();
        for (AuditAction r : result) {
            AuditReportDTO dto = new AuditReportDTO();
            dtos.add(dto);
            dto.setLogin(r.getLogin());
            dto.setType(r.getType());
            dto.setContext(r.getContext());
            dto.setDate(r.getDate());
            dto.setText(r.getText());
        }
        return dtos;
    }

    @Override
    protected SearchParam buildSearchAuditSearchParam(AuditReportSearchDTO criteria) {
        SearchParam searchParam;
        block16: {
            BooleanExpression expression = null;
            if (!Strings.isEmpty((String)criteria.getLogin())) {
                expression = SLUtil.and(expression, QAuditAction.auditAction.login.eq((Object)criteria.getLogin()));
            }
            if (criteria.getType() != null) {
                expression = SLUtil.and(expression, QAuditAction.auditAction.type.eq((Object)criteria.getType()));
            }
            if (criteria.getContext() != null) {
                expression = SLUtil.and(expression, QAuditAction.auditAction.context.eq((Object)criteria.getContext()));
            }
            if (!Strings.isEmpty((String)criteria.getUsername())) {
                JPASubQuery sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.name.lower().like(criteria.getUsername().toLowerCase())});
                expression = SLUtil.and(expression, QAuditAction.auditAction.userId.in((CollectionExpression)sq.list((Expression)QUser.user.id)));
            }
            if (criteria.getBegin() != null) {
                expression = SLUtil.and(expression, QAuditAction.auditAction.date.goe((Comparable)criteria.getBegin()));
            }
            if (criteria.getEnd() != null) {
                expression = SLUtil.and(expression, QAuditAction.auditAction.date.loe((Comparable)criteria.getEnd()));
            }
            searchParam = new SearchParam();
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block16;
            switch (criteria.getOrderBy()) {
                case "login": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAuditAction.auditAction.login.asc() : QAuditAction.auditAction.login.desc());
                    break;
                }
                case "date": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAuditAction.auditAction.date.asc() : QAuditAction.auditAction.date.desc());
                }
            }
        }
        return searchParam;
    }
}

