/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IApplicationSettingDAO;
import pt.efacec.smartlighting.common.core.entity.ApplicationSetting;
import pt.efacec.smartlighting.common.core.entity.QApplicationSetting;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class ApplicationSettingDAOBase
implements IApplicationSettingDAO {
    private static final Log logger = Log.getLogger(ApplicationSettingDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from ApplicationSetting e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(ApplicationSetting entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public ApplicationSetting save(ApplicationSetting entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if ((temp = entity.getValue()) != null && temp.length() > 256) {
            entity.setValue(temp.substring(0, 256));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (ApplicationSetting)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public ApplicationSetting findPersisted(ApplicationSetting entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            ApplicationSetting persisted = (ApplicationSetting)this.em.find(ApplicationSetting.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public ApplicationSetting findById(String entityId) {
        return (ApplicationSetting)this.em.find(ApplicationSetting.class, (Object)entityId);
    }

    @Override
    public List<ApplicationSetting> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QApplicationSetting.applicationSetting})).list((Expression)QApplicationSetting.applicationSetting);
    }

    @Override
    public ApplicationSetting findByName(String name) {
        if (name == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ApplicationSettingDAO.findByName", "name"});
        }
        try {
            return this.handleFindByName(name);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findByName.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findByName.", e);
        }
    }

    protected abstract ApplicationSetting handleFindByName(String var1);
}

