/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IAlarmDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.AlarmReportDTO;
import pt.efacec.smartlighting.common.core.dto.AlarmReportSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class AlarmDAOBase
implements IAlarmDAO {
    private static final Log logger = Log.getLogger(AlarmDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Alarm e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Alarm entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Alarm save(Alarm entity) {
        String temp = null;
        temp = entity.getDescription();
        if (temp != null && temp.length() > 255) {
            entity.setDescription(temp.substring(0, 255));
        }
        if ((temp = entity.getDtcName()) != null && temp.length() > 255) {
            entity.setDtcName(temp.substring(0, 255));
        }
        if ((temp = entity.getServiceName()) != null && temp.length() > 255) {
            entity.setServiceName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Alarm)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Alarm findPersisted(Alarm entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Alarm persisted = (Alarm)this.em.find(Alarm.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Alarm findById(String entityId) {
        return (Alarm)this.em.find(Alarm.class, (Object)entityId);
    }

    @Override
    public List<Alarm> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm})).list((Expression)QAlarm.alarm);
    }

    @Override
    public void loadDtc(Alarm entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getDtcId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public List<Alarm> findAllByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm})).where(new Predicate[]{dtcId == null ? QAlarm.alarm.dtcId.isNull() : QAlarm.alarm.dtcId.eq((Object)dtcId)})).list((Expression)QAlarm.alarm);
    }

    @Override
    public void loadService(Alarm entity) {
        if (entity != null) {
            entity.setService(this.getService(entity.getServiceId()));
        }
    }

    @Override
    public DtcService getService(String dtcServiceId) {
        if (dtcServiceId != null) {
            return (DtcService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.id.eq((Object)dtcServiceId).and((Predicate)QDtcService.dtcService.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtcService.dtcService);
        }
        return null;
    }

    @Override
    public List<Alarm> findAllByService(String dtcServiceId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm})).where(new Predicate[]{dtcServiceId == null ? QAlarm.alarm.serviceId.isNull() : QAlarm.alarm.serviceId.eq((Object)dtcServiceId)})).list((Expression)QAlarm.alarm);
    }

    @Override
    public Page<AlarmReportDTO> searchAlarms(AlarmReportSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"AlarmDAO.searchAlarms", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchAlarmsSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchAlarms(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchAlarms(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<AlarmReportDTO> list = this.queryForSearchAlarms(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchAlarms.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchAlarms.", e);
        }
    }

    protected JPAQuery createQueryForSearchAlarms(AlarmReportSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm});
    }

    protected abstract List<AlarmReportDTO> queryForSearchAlarms(JPAQuery var1);

    protected abstract SearchParam buildSearchAlarmsSearchParam(AlarmReportSearchDTO var1);
}

