/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.AlarmDAOBase;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcServiceDAO;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.AlarmReportDTO;
import pt.efacec.smartlighting.common.core.dto.AlarmReportSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="alarm")
public class AlarmDAO
extends AlarmDAOBase {
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IDtcServiceDAO dtcServiceDAO;

    @Override
    public Alarm save(Alarm entity) {
        DtcService srv;
        if (entity.getDtcId() != null) {
            Dtc dtc = this.dtcDAO.findById(entity.getDtcId());
            entity.setDtcName(dtc.getName());
        }
        if (entity.getDtcId() != null && entity.getServiceName() != null && (srv = this.dtcServiceDAO.findByNameAndDtc(entity.getServiceName(), entity.getDtcId())) != null) {
            entity.setServiceId(srv.getId());
        }
        return super.save(entity);
    }

    @Override
    protected List<AlarmReportDTO> queryForSearchAlarms(JPAQuery query) {
        List result = query.list((Expression)QAlarm.alarm);
        ArrayList<AlarmReportDTO> dtos = new ArrayList<AlarmReportDTO>();
        for (Alarm r : result) {
            AlarmReportDTO dto = new AlarmReportDTO();
            dtos.add(dto);
            dto.setDtcId(r.getDtcId());
            dto.setDescription(r.getDescription());
            dto.setDtcName(r.getDtcName());
            dto.setServiceName(r.getServiceName());
            dto.setNature(r.getNature());
            dto.setDate(r.getErrorDate());
            dto.setType(r.getType());
        }
        return dtos;
    }

    @Override
    protected SearchParam buildSearchAlarmsSearchParam(AlarmReportSearchDTO criteria) {
        SearchParam searchParam;
        block27: {
            JPASubQuery sq;
            BooleanExpression expression = null;
            if (!Strings.isEmpty((String)criteria.getDtcName())) {
                expression = SLUtil.and(expression, QAlarm.alarm.dtcName.lower().like(criteria.getDtcName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getServiceName())) {
                expression = SLUtil.and(expression, QAlarm.alarm.serviceName.lower().like(criteria.getServiceName().toLowerCase()));
            }
            if (criteria.getType() != null) {
                expression = SLUtil.and(expression, QAlarm.alarm.type.eq((Object)criteria.getType()));
            }
            if (criteria.getNature() != null) {
                expression = SLUtil.and(expression, QAlarm.alarm.nature.eq((Object)criteria.getNature()));
            }
            if (!Strings.isEmpty((String)criteria.getDistrictId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.districtId.eq((Object)criteria.getDistrictId())});
                expression = SLUtil.and(expression, QAlarm.alarm.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getMunicipalityId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.municipalityId.eq((Object)criteria.getMunicipalityId())});
                expression = SLUtil.and(expression, QAlarm.alarm.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getOperationalAreaId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.operationalAreaId.eq((Object)criteria.getOperationalAreaId())});
                expression = SLUtil.and(expression, QAlarm.alarm.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getClientId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.clientId.eq((Object)criteria.getClientId())});
                expression = SLUtil.and(expression, QAlarm.alarm.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (criteria.getBegin() != null) {
                expression = SLUtil.and(expression, QAlarm.alarm.errorDate.goe((Comparable)criteria.getBegin()));
            }
            if (criteria.getEnd() != null) {
                expression = SLUtil.and(expression, QAlarm.alarm.errorDate.loe((Comparable)criteria.getEnd()));
            }
            if (!Strings.isEmpty((String)criteria.getDescription())) {
                expression = SLUtil.and(expression, QAlarm.alarm.description.lower().like(criteria.getDescription().toLowerCase()));
            }
            searchParam = new SearchParam();
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block27;
            switch (criteria.getOrderBy()) {
                case "description": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAlarm.alarm.description.asc() : QAlarm.alarm.description.desc());
                    break;
                }
                case "dtcName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAlarm.alarm.dtcName.asc() : QAlarm.alarm.dtcName.desc());
                    break;
                }
                case "serviceName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAlarm.alarm.serviceName.asc() : QAlarm.alarm.serviceName.desc());
                    break;
                }
                case "date": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QAlarm.alarm.errorDate.asc() : QAlarm.alarm.errorDate.desc());
                }
            }
        }
        return searchParam;
    }
}

