/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.Time;
import net.sourceforge.zmanim.util.Zman;

public class ZmanimFormatter {
    private boolean prependZeroHours;
    private boolean useSeconds;
    private boolean useMillis;
    boolean useDecimal;
    private static DecimalFormat minuteSecondNF = new DecimalFormat("00");
    private DecimalFormat hourNF;
    private static DecimalFormat milliNF = new DecimalFormat("000");
    private SimpleDateFormat dateFormat;
    public static final int SEXAGESIMAL_XSD_FORMAT = 0;
    private int timeFormat = 0;
    public static final int DECIMAL_FORMAT = 1;
    public static final int SEXAGESIMAL_FORMAT = 2;
    public static final int SEXAGESIMAL_SECONDS_FORMAT = 3;
    public static final int SEXAGESIMAL_MILLIS_FORMAT = 4;
    static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final int XSD_DURATION_FORMAT = 5;

    public ZmanimFormatter() {
        this(0, new SimpleDateFormat("h:mm:ss"));
    }

    public ZmanimFormatter(int format, SimpleDateFormat dateFormat) {
        String hourFormat = "0";
        if (this.prependZeroHours) {
            hourFormat = "00";
        }
        this.hourNF = new DecimalFormat(hourFormat);
        this.setTimeFormat(format);
        this.setDateFormat(dateFormat);
    }

    public void setTimeFormat(int format) {
        this.timeFormat = format;
        switch (format) {
            case 0: {
                this.setSettings(true, true, true);
                break;
            }
            case 2: {
                this.setSettings(false, false, false);
                break;
            }
            case 3: {
                this.setSettings(false, true, false);
                break;
            }
            case 4: {
                this.setSettings(false, true, true);
                break;
            }
            default: {
                this.useDecimal = true;
            }
        }
    }

    public void setDateFormat(SimpleDateFormat sdf) {
        this.dateFormat = sdf;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void setSettings(boolean prependZeroHours, boolean useSeconds, boolean useMillis) {
        this.prependZeroHours = prependZeroHours;
        this.useSeconds = useSeconds;
        this.useMillis = useMillis;
    }

    public String format(double milliseconds) {
        return this.format((int)milliseconds);
    }

    public String format(int millis) {
        return this.format(new Time(millis));
    }

    public String format(Time time) {
        if (this.timeFormat == 5) {
            return this.formatXSDDurationTime(time);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.hourNF.format(time.getHours()));
        sb.append(":");
        sb.append(minuteSecondNF.format(time.getMinutes()));
        if (this.useSeconds) {
            sb.append(":");
            sb.append(minuteSecondNF.format(time.getSeconds()));
        }
        if (this.useMillis) {
            sb.append(".");
            sb.append(milliNF.format(time.getMilliseconds()));
        }
        return sb.toString();
    }

    public String formatDateTime(Date dateTime, Calendar calendar) {
        this.dateFormat.setCalendar(calendar);
        if (this.dateFormat.toPattern().equals("yyyy-MM-dd'T'HH:mm:ss")) {
            return this.getXSDateTime(dateTime, calendar);
        }
        return this.dateFormat.format(dateTime);
    }

    public String getXSDateTime(Date dateTime, Calendar cal) {
        String xsdDateTimeFormat = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(xsdDateTimeFormat);
        StringBuffer buff = new StringBuffer(dateFormat.format(dateTime));
        int offset = cal.get(15) + cal.get(16);
        if (offset == 0) {
            buff.append("Z");
        } else {
            int hrs = offset / 3600000;
            int min = offset % 3600000;
            char posneg = hrs < 0 ? (char)'-' : '+';
            buff.append(posneg + ZmanimFormatter.formatDigits(hrs) + ':' + ZmanimFormatter.formatDigits(min));
        }
        return buff.toString();
    }

    private static String formatDigits(int digits) {
        String dd = String.valueOf(Math.abs(digits));
        return dd.length() == 1 ? '0' + dd : dd;
    }

    public String formatXSDDurationTime(long millis) {
        return this.formatXSDDurationTime(new Time(millis));
    }

    public String formatXSDDurationTime(Time time) {
        StringBuffer duration = new StringBuffer();
        duration.append("P");
        if (time.getHours() != 0 || time.getMinutes() != 0 || time.getSeconds() != 0 || time.getMilliseconds() != 0) {
            duration.append("T");
            if (time.getHours() != 0) {
                duration.append(time.getHours() + "H");
            }
            if (time.getMinutes() != 0) {
                duration.append(time.getMinutes() + "M");
            }
            if (time.getSeconds() != 0 || time.getMilliseconds() != 0) {
                duration.append(time.getSeconds() + "." + milliNF.format(time.getMilliseconds()));
                duration.append("S");
            }
            if (duration.length() == 1) {
                duration.append("T0S");
            }
            if (time.isNegative()) {
                duration.insert(0, "-");
            }
        }
        return duration.toString();
    }

    public static String toXML(AstronomicalCalendar ac) {
        int i;
        ZmanimFormatter formatter = new ZmanimFormatter(5, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String output = "<";
        if (ac.getClass().getName().endsWith("AstronomicalCalendar")) {
            output = output + "AstronomicalTimes";
        } else if (ac.getClass().getName().endsWith("ZmanimCalendar")) {
            output = output + "Zmanim";
        }
        output = output + " date=\"" + df.format(ac.getCalendar().getTime()) + "\"";
        output = output + " type=\"" + ac.getClass().getName() + "\"";
        output = output + " algorithm=\"" + ac.getAstronomicalCalculator().getCalculatorName() + "\"";
        output = output + " location=\"" + ac.getGeoLocation().getLocationName() + "\"";
        output = output + " latitude=\"" + ac.getGeoLocation().getLatitude() + "\"";
        output = output + " longitude=\"" + ac.getGeoLocation().getLongitude() + "\"";
        output = output + " elevation=\"" + ac.getGeoLocation().getElevation() + "\"";
        output = output + " timeZoneName=\"" + ac.getGeoLocation().getTimeZone().getDisplayName() + "\"";
        output = output + " timeZoneID=\"" + ac.getGeoLocation().getTimeZone().getID() + "\"";
        output = output + " timeZoneOffset=\"" + (double)ac.getGeoLocation().getTimeZone().getOffset(ac.getCalendar().getTimeInMillis()) / 3600000.0 + "\"";
        output = output + ">\n";
        Method[] theMethods = ac.getClass().getMethods();
        String tagName = "";
        Object value = null;
        ArrayList<Zman> dateList = new ArrayList<Zman>();
        ArrayList<Zman> durationList = new ArrayList<Zman>();
        ArrayList<String> otherList = new ArrayList<String>();
        for (int i2 = 0; i2 < theMethods.length; ++i2) {
            if (!ZmanimFormatter.includeMethod(theMethods[i2])) continue;
            tagName = theMethods[i2].getName().substring(3);
            try {
                value = theMethods[i2].invoke((Object)ac, (Object[])null);
                if (value == null) {
                    otherList.add("<" + tagName + ">N/A</" + tagName + ">");
                    continue;
                }
                if (value instanceof Date) {
                    dateList.add(new Zman((Date)value, tagName));
                    continue;
                }
                if (value instanceof Long) {
                    durationList.add(new Zman((int)((Long)value).longValue(), tagName));
                    continue;
                }
                otherList.add("<" + tagName + ">" + value + "</" + tagName + ">");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Collections.sort(dateList, Zman.DATE_ORDER);
        for (i = 0; i < dateList.size(); ++i) {
            Zman zman = (Zman)dateList.get(i);
            output = output + "\t<" + zman.getZmanLabel();
            output = output + ">";
            output = output + formatter.formatDateTime(zman.getZman(), ac.getCalendar()) + "</" + zman.getZmanLabel() + ">\n";
        }
        Collections.sort(durationList, Zman.DURATION_ORDER);
        for (i = 0; i < durationList.size(); ++i) {
            Zman zman = (Zman)durationList.get(i);
            output = output + "\t<" + zman.getZmanLabel();
            output = output + ">";
            output = output + formatter.format((int)zman.getDuration()) + "</" + zman.getZmanLabel() + ">\n";
        }
        for (i = 0; i < otherList.size(); ++i) {
            output = output + "\t" + otherList.get(i) + "\n";
        }
        if (ac.getClass().getName().endsWith("AstronomicalCalendar")) {
            output = output + "</AstronomicalTimes>";
        } else if (ac.getClass().getName().endsWith("ZmanimCalendar")) {
            output = output + "</Zmanim>";
        }
        return output;
    }

    private static boolean includeMethod(Method method) {
        ArrayList methodWhiteList = new ArrayList();
        ArrayList methodBlackList = new ArrayList();
        if (methodWhiteList.contains(method.getName())) {
            return true;
        }
        if (methodBlackList.contains(method.getName())) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        if (!method.getName().startsWith("get")) {
            return false;
        }
        return method.getReturnType().getName().endsWith("Date") || method.getReturnType().getName().endsWith("long");
    }
}

