/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.AstronomicalCalculator;

public class ZmanimCalculator
extends AstronomicalCalculator {
    private String calculatorName = "US Naval Almanac Algorithm";

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public double getUTCSunrise(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        double UTx;
        double RAx;
        double Lx;
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        double lngHour = astronomicalCalendar.getGeoLocation().getLongitude() / 15.0;
        double t = (double)astronomicalCalendar.getCalendar().get(6) + (6.0 - lngHour) / 24.0;
        double m = 0.9856 * t - 3.289;
        double l = m + 1.916 * Math.sin(Math.toRadians(m)) + 0.02 * Math.sin(Math.toRadians(2.0 * m)) + 282.634;
        while (l < 0.0) {
            l = Lx = l + 360.0;
        }
        while (l >= 360.0) {
            l = Lx = l - 360.0;
        }
        double RA = Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(l))));
        while (RA < 0.0) {
            RA = RAx = RA + 360.0;
        }
        while (RA >= 360.0) {
            RA = RAx = RA - 360.0;
        }
        double lQuadrant = Math.floor(l / 90.0) * 90.0;
        double raQuadrant = Math.floor(RA / 90.0) * 90.0;
        RA += lQuadrant - raQuadrant;
        double sinDec = 0.39782 * Math.sin(Math.toRadians(l));
        double cosDec = Math.cos(Math.asin(sinDec));
        double cosH = (Math.cos(Math.toRadians(zenith)) - sinDec * Math.sin(Math.toRadians(astronomicalCalendar.getGeoLocation().getLatitude()))) / (cosDec * Math.cos(Math.toRadians(astronomicalCalendar.getGeoLocation().getLatitude())));
        double H = 360.0 - Math.toDegrees(Math.acos(cosH));
        double T = (H /= 15.0) + (RA /= 15.0) - 0.06571 * t - 6.622;
        double UT = T - lngHour;
        while (UT < 0.0) {
            UT = UTx = UT + 24.0;
        }
        while (UT >= 24.0) {
            UT = UTx = UT - 24.0;
        }
        return UT;
    }

    public double getUTCSunset(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        double UTx;
        double RAx;
        double Lx;
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        int N = astronomicalCalendar.getCalendar().get(6);
        double lngHour = astronomicalCalendar.getGeoLocation().getLongitude() / 15.0;
        double t = (double)N + (18.0 - lngHour) / 24.0;
        double M = 0.9856 * t - 3.289;
        double L = M + 1.916 * Math.sin(Math.toRadians(M)) + 0.02 * Math.sin(Math.toRadians(2.0 * M)) + 282.634;
        while (L < 0.0) {
            L = Lx = L + 360.0;
        }
        while (L >= 360.0) {
            L = Lx = L - 360.0;
        }
        double RA = Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(L))));
        while (RA < 0.0) {
            RA = RAx = RA + 360.0;
        }
        while (RA >= 360.0) {
            RA = RAx = RA - 360.0;
        }
        double Lquadrant = Math.floor(L / 90.0) * 90.0;
        double RAquadrant = Math.floor(RA / 90.0) * 90.0;
        RA += Lquadrant - RAquadrant;
        double sinDec = 0.39782 * Math.sin(Math.toRadians(L));
        double cosDec = Math.cos(Math.asin(sinDec));
        double cosH = (Math.cos(Math.toRadians(zenith)) - sinDec * Math.sin(Math.toRadians(astronomicalCalendar.getGeoLocation().getLatitude()))) / (cosDec * Math.cos(Math.toRadians(astronomicalCalendar.getGeoLocation().getLatitude())));
        double H = Math.toDegrees(Math.acos(cosH));
        double T = (H /= 15.0) + (RA /= 15.0) - 0.06571 * t - 6.622;
        double UT = T - lngHour;
        while (UT < 0.0) {
            UT = UTx = UT + 24.0;
        }
        while (UT >= 24.0) {
            UT = UTx = UT - 24.0;
        }
        return UT;
    }
}

