/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.AstronomicalCalculator;

public class SunTimesCalculator
extends AstronomicalCalculator {
    private String calculatorName = "US Naval Almanac Algorithm";
    public static final double ZENITH = 90.83333333333333;
    private static final int TYPE_SUNRISE = 0;
    private static final int TYPE_SUNSET = 1;
    private static final double DEG_PER_HOUR = 15.0;

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public double getUTCSunrise(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        double doubleTime = Double.NaN;
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        doubleTime = SunTimesCalculator.getTimeUTC(astronomicalCalendar.getCalendar().get(1), astronomicalCalendar.getCalendar().get(2) + 1, astronomicalCalendar.getCalendar().get(5), astronomicalCalendar.getGeoLocation().getLongitude(), astronomicalCalendar.getGeoLocation().getLatitude(), zenith, 0);
        return doubleTime;
    }

    public double getUTCSunset(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        double doubleTime = Double.NaN;
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        doubleTime = SunTimesCalculator.getTimeUTC(astronomicalCalendar.getCalendar().get(1), astronomicalCalendar.getCalendar().get(2) + 1, astronomicalCalendar.getCalendar().get(5), astronomicalCalendar.getGeoLocation().getLongitude(), astronomicalCalendar.getGeoLocation().getLatitude(), zenith, 1);
        return doubleTime;
    }

    private static double sinDeg(double deg) {
        return Math.sin(deg * 2.0 * Math.PI / 360.0);
    }

    private static double acosDeg(double x) {
        return Math.acos(x) * 360.0 / (Math.PI * 2);
    }

    private static double asinDeg(double x) {
        return Math.asin(x) * 360.0 / (Math.PI * 2);
    }

    private static double tanDeg(double deg) {
        return Math.tan(deg * 2.0 * Math.PI / 360.0);
    }

    private static double cosDeg(double deg) {
        return Math.cos(deg * 2.0 * Math.PI / 360.0);
    }

    private static int getDayOfYear(int year, int month, int day) {
        int n1 = 275 * month / 9;
        int n2 = (month + 9) / 12;
        int n3 = 1 + (year - 4 * (year / 4) + 2) / 3;
        int n = n1 - n2 * n3 + day - 30;
        return n;
    }

    private static double getHoursFromMeridian(double longitude) {
        return longitude / 15.0;
    }

    private static double getApproxTimeDays(int dayOfYear, double hoursFromMeridian, int type) {
        if (type == 0) {
            return (double)dayOfYear + (6.0 - hoursFromMeridian) / 24.0;
        }
        return (double)dayOfYear + (18.0 - hoursFromMeridian) / 24.0;
    }

    private static double getMeanAnomaly(int dayOfYear, double longitude, int type) {
        return 0.9856 * SunTimesCalculator.getApproxTimeDays(dayOfYear, SunTimesCalculator.getHoursFromMeridian(longitude), type) - 3.289;
    }

    private static double getSunTrueLongitude(double sunMeanAnomaly) {
        double l = sunMeanAnomaly + 1.916 * SunTimesCalculator.sinDeg(sunMeanAnomaly) + 0.02 * SunTimesCalculator.sinDeg(2.0 * sunMeanAnomaly) + 282.634;
        if (l >= 360.0) {
            l -= 360.0;
        }
        if (l < 0.0) {
            l += 360.0;
        }
        return l;
    }

    private static double getSunRightAscensionHours(double sunTrueLongitude) {
        double a = 0.91764 * SunTimesCalculator.tanDeg(sunTrueLongitude);
        double ra = 57.29577951308232 * Math.atan(a);
        double lQuadrant = Math.floor(sunTrueLongitude / 90.0) * 90.0;
        double raQuadrant = Math.floor(ra / 90.0) * 90.0;
        return (ra += lQuadrant - raQuadrant) / 15.0;
    }

    private static double getCosLocalHourAngle(double sunTrueLongitude, double latitude, double zenith) {
        double sinDec = 0.39782 * SunTimesCalculator.sinDeg(sunTrueLongitude);
        double cosDec = SunTimesCalculator.cosDeg(SunTimesCalculator.asinDeg(sinDec));
        double cosH = (SunTimesCalculator.cosDeg(zenith) - sinDec * SunTimesCalculator.sinDeg(latitude)) / (cosDec * SunTimesCalculator.cosDeg(latitude));
        return cosH;
    }

    private static double getLocalMeanTime(double localHour, double sunRightAscensionHours, double approxTimeDays) {
        return localHour + sunRightAscensionHours - 0.06571 * approxTimeDays - 6.622;
    }

    private static double getTimeUTC(int year, int month, int day, double longitude, double latitude, double zenith, int type) {
        double pocessedTime;
        int dayOfYear = SunTimesCalculator.getDayOfYear(year, month, day);
        double sunMeanAnomaly = SunTimesCalculator.getMeanAnomaly(dayOfYear, longitude, type);
        double sunTrueLong = SunTimesCalculator.getSunTrueLongitude(sunMeanAnomaly);
        double sunRightAscensionHours = SunTimesCalculator.getSunRightAscensionHours(sunTrueLong);
        double cosLocalHourAngle = SunTimesCalculator.getCosLocalHourAngle(sunTrueLong, latitude, zenith);
        double localHourAngle = 0.0;
        if (type == 0) {
            if (cosLocalHourAngle > 1.0) {
                // empty if block
            }
            localHourAngle = 360.0 - SunTimesCalculator.acosDeg(cosLocalHourAngle);
        } else {
            if (cosLocalHourAngle < -1.0) {
                // empty if block
            }
            localHourAngle = SunTimesCalculator.acosDeg(cosLocalHourAngle);
        }
        double localHour = localHourAngle / 15.0;
        double localMeanTime = SunTimesCalculator.getLocalMeanTime(localHour, sunRightAscensionHours, SunTimesCalculator.getApproxTimeDays(dayOfYear, SunTimesCalculator.getHoursFromMeridian(longitude), type));
        for (pocessedTime = localMeanTime - SunTimesCalculator.getHoursFromMeridian(longitude); pocessedTime < 0.0; pocessedTime += 24.0) {
        }
        while (pocessedTime >= 24.0) {
            pocessedTime -= 24.0;
        }
        return pocessedTime;
    }
}

