/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import java.util.Calendar;
import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.AstronomicalCalculator;

public class NOAACalculator
extends AstronomicalCalculator {
    private String calculatorName = "US National Oceanic and Atmospheric Administration Algorithm";

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public double getUTCSunrise(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        double sunRise = NOAACalculator.calcSunriseUTC(NOAACalculator.calcJD(astronomicalCalendar.getCalendar()), astronomicalCalendar.getGeoLocation().getLatitude(), -astronomicalCalendar.getGeoLocation().getLongitude(), zenith);
        return sunRise / 60.0;
    }

    public double getUTCSunset(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        double sunSet = NOAACalculator.calcSunsetUTC(NOAACalculator.calcJD(astronomicalCalendar.getCalendar()), astronomicalCalendar.getGeoLocation().getLatitude(), -astronomicalCalendar.getGeoLocation().getLongitude(), zenith);
        return sunSet / 60.0;
    }

    private static double calcJD(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        if (month <= 2) {
            --year;
            month += 12;
        }
        double A = Math.floor(year / 100);
        double B = 2.0 - A + Math.floor(A / 4.0);
        return Math.floor(365.25 * (double)(year + 4716)) + Math.floor(30.6001 * (double)(month + 1)) + (double)day + B - 1524.5;
    }

    private static double calcTimeJulianCent(double jd) {
        return (jd - 2451545.0) / 36525.0;
    }

    private static double calcJDFromJulianCent(double t) {
        return t * 36525.0 + 2451545.0;
    }

    private static double calcGeomMeanLongSun(double t) {
        double L0;
        for (L0 = 280.46646 + t * (36000.76983 + 3.032E-4 * t); L0 > 360.0; L0 -= 360.0) {
        }
        while (L0 < 0.0) {
            L0 += 360.0;
        }
        return L0;
    }

    private static double calcGeomMeanAnomalySun(double t) {
        double M = 357.52911 + t * (35999.05029 - 1.537E-4 * t);
        return M;
    }

    private static double calcEccentricityEarthOrbit(double t) {
        double e = 0.016708634 - t * (4.2037E-5 + 1.267E-7 * t);
        return e;
    }

    private static double calcSunEqOfCenter(double t) {
        double m = NOAACalculator.calcGeomMeanAnomalySun(t);
        double mrad = Math.toRadians(m);
        double sinm = Math.sin(mrad);
        double sin2m = Math.sin(mrad + mrad);
        double sin3m = Math.sin(mrad + mrad + mrad);
        double C = sinm * (1.914602 - t * (0.004817 + 1.4E-5 * t)) + sin2m * (0.019993 - 1.01E-4 * t) + sin3m * 2.89E-4;
        return C;
    }

    private static double calcSunTrueLong(double t) {
        double l0 = NOAACalculator.calcGeomMeanLongSun(t);
        double c = NOAACalculator.calcSunEqOfCenter(t);
        double O = l0 + c;
        return O;
    }

    private static double calcSunApparentLong(double t) {
        double o = NOAACalculator.calcSunTrueLong(t);
        double omega = 125.04 - 1934.136 * t;
        double lambda = o - 0.00569 - 0.00478 * Math.sin(Math.toRadians(omega));
        return lambda;
    }

    private static double calcMeanObliquityOfEcliptic(double t) {
        double seconds = 21.448 - t * (46.815 + t * (5.9E-4 - t * 0.001813));
        double e0 = 23.0 + (26.0 + seconds / 60.0) / 60.0;
        return e0;
    }

    private static double calcObliquityCorrection(double t) {
        double e0 = NOAACalculator.calcMeanObliquityOfEcliptic(t);
        double omega = 125.04 - 1934.136 * t;
        double e = e0 + 0.00256 * Math.cos(Math.toRadians(omega));
        return e;
    }

    private static double calcSunDeclination(double t) {
        double e = NOAACalculator.calcObliquityCorrection(t);
        double lambda = NOAACalculator.calcSunApparentLong(t);
        double sint = Math.sin(Math.toRadians(e)) * Math.sin(Math.toRadians(lambda));
        double theta = Math.toDegrees(Math.asin(sint));
        return theta;
    }

    private static double calcEquationOfTime(double t) {
        double epsilon = NOAACalculator.calcObliquityCorrection(t);
        double l0 = NOAACalculator.calcGeomMeanLongSun(t);
        double e = NOAACalculator.calcEccentricityEarthOrbit(t);
        double m = NOAACalculator.calcGeomMeanAnomalySun(t);
        double y = Math.tan(Math.toRadians(epsilon) / 2.0);
        y *= y;
        double sin2l0 = Math.sin(2.0 * Math.toRadians(l0));
        double sinm = Math.sin(Math.toRadians(m));
        double cos2l0 = Math.cos(2.0 * Math.toRadians(l0));
        double sin4l0 = Math.sin(4.0 * Math.toRadians(l0));
        double sin2m = Math.sin(2.0 * Math.toRadians(m));
        double Etime = y * sin2l0 - 2.0 * e * sinm + 4.0 * e * y * sinm * cos2l0 - 0.5 * y * y * sin4l0 - 1.25 * e * e * sin2m;
        return Math.toDegrees(Etime) * 4.0;
    }

    private static double calcHourAngleSunrise(double lat, double solarDec, double zenith) {
        double latRad = Math.toRadians(lat);
        double sdRad = Math.toRadians(solarDec);
        double HA = Math.acos(Math.cos(Math.toRadians(zenith)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return HA;
    }

    private static double calcHourAngleSunset(double lat, double solarDec, double zenith) {
        double latRad = Math.toRadians(lat);
        double sdRad = Math.toRadians(solarDec);
        double HA = Math.acos(Math.cos(Math.toRadians(zenith)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return -HA;
    }

    private static double calcSunriseUTC(double JD, double latitude, double longitude, double zenith) {
        double t = NOAACalculator.calcTimeJulianCent(JD);
        double noonmin = NOAACalculator.calcSolNoonUTC(t, longitude);
        double tnoon = NOAACalculator.calcTimeJulianCent(JD + noonmin / 1440.0);
        double eqTime = NOAACalculator.calcEquationOfTime(tnoon);
        double solarDec = NOAACalculator.calcSunDeclination(tnoon);
        double hourAngle = NOAACalculator.calcHourAngleSunrise(latitude, solarDec, zenith);
        double delta = longitude - Math.toDegrees(hourAngle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqTime;
        double newt = NOAACalculator.calcTimeJulianCent(NOAACalculator.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqTime = NOAACalculator.calcEquationOfTime(newt);
        solarDec = NOAACalculator.calcSunDeclination(newt);
        hourAngle = NOAACalculator.calcHourAngleSunrise(latitude, solarDec, zenith);
        delta = longitude - Math.toDegrees(hourAngle);
        timeDiff = 4.0 * delta;
        timeUTC = 720.0 + timeDiff - eqTime;
        return timeUTC;
    }

    private static double calcSolNoonUTC(double t, double longitude) {
        double tnoon = NOAACalculator.calcTimeJulianCent(NOAACalculator.calcJDFromJulianCent(t) + longitude / 360.0);
        double eqTime = NOAACalculator.calcEquationOfTime(tnoon);
        double solNoonUTC = 720.0 + longitude * 4.0 - eqTime;
        double newt = NOAACalculator.calcTimeJulianCent(NOAACalculator.calcJDFromJulianCent(t) - 0.5 + solNoonUTC / 1440.0);
        eqTime = NOAACalculator.calcEquationOfTime(newt);
        return 720.0 + longitude * 4.0 - eqTime;
    }

    private static double calcSunsetUTC(double JD, double latitude, double longitude, double zenith) {
        double t = NOAACalculator.calcTimeJulianCent(JD);
        double noonmin = NOAACalculator.calcSolNoonUTC(t, longitude);
        double tnoon = NOAACalculator.calcTimeJulianCent(JD + noonmin / 1440.0);
        double eqTime = NOAACalculator.calcEquationOfTime(tnoon);
        double solarDec = NOAACalculator.calcSunDeclination(tnoon);
        double hourAngle = NOAACalculator.calcHourAngleSunset(latitude, solarDec, zenith);
        double delta = longitude - Math.toDegrees(hourAngle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqTime;
        double newt = NOAACalculator.calcTimeJulianCent(NOAACalculator.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqTime = NOAACalculator.calcEquationOfTime(newt);
        solarDec = NOAACalculator.calcSunDeclination(newt);
        hourAngle = NOAACalculator.calcHourAngleSunset(latitude, solarDec, zenith);
        delta = longitude - Math.toDegrees(hourAngle);
        timeDiff = 4.0 * delta;
        return 720.0 + timeDiff - eqTime;
    }
}

