/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import java.util.Calendar;
import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.AstronomicalCalculator;

public class JSuntimeCalculator
extends AstronomicalCalculator {
    private String calculatorName = "US National Oceanic and Atmospheric Administration Algorithm";

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public double getUTCSunrise(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        double timeMins = JSuntimeCalculator.morningPhenomenon(JSuntimeCalculator.dateToJulian(astronomicalCalendar.getCalendar()), astronomicalCalendar.getGeoLocation().getLatitude(), -astronomicalCalendar.getGeoLocation().getLongitude(), zenith);
        return timeMins / 60.0;
    }

    public double getUTCSunset(AstronomicalCalendar astronomicalCalendar, double zenith, boolean adjustForElevation) {
        zenith = adjustForElevation ? this.adjustZenith(zenith, astronomicalCalendar.getGeoLocation().getElevation()) : this.adjustZenith(zenith, 0.0);
        double timeMins = JSuntimeCalculator.eveningPhenomenon(JSuntimeCalculator.dateToJulian(astronomicalCalendar.getCalendar()), astronomicalCalendar.getGeoLocation().getLatitude(), -astronomicalCalendar.getGeoLocation().getLongitude(), zenith);
        return timeMins / 60.0;
    }

    private static double morningPhenomenon(double julian, double latitude, double longitude, double zenithDistance) {
        double t = JSuntimeCalculator.julianDayToJulianCenturies(julian);
        double eqtime = JSuntimeCalculator.equationOfTime(t);
        double solarDec = JSuntimeCalculator.sunDeclination(t);
        double hourangle = JSuntimeCalculator.hourAngleMorning(latitude, solarDec, zenithDistance);
        double delta = longitude - Math.toDegrees(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = JSuntimeCalculator.julianDayToJulianCenturies(JSuntimeCalculator.julianCenturiesToJulianDay(t) + timeUTC / 1440.0);
        eqtime = JSuntimeCalculator.equationOfTime(newt);
        solarDec = JSuntimeCalculator.sunDeclination(newt);
        hourangle = JSuntimeCalculator.hourAngleMorning(latitude, solarDec, zenithDistance);
        delta = longitude - Math.toDegrees(hourangle);
        timeDiff = 4.0 * delta;
        double morning = 720.0 + timeDiff - eqtime;
        return morning;
    }

    private static double eveningPhenomenon(double julian, double latitude, double longitude, double zenithDistance) {
        double t = JSuntimeCalculator.julianDayToJulianCenturies(julian);
        double eqtime = JSuntimeCalculator.equationOfTime(t);
        double solarDec = JSuntimeCalculator.sunDeclination(t);
        double hourangle = JSuntimeCalculator.hourAngleEvening(latitude, solarDec, zenithDistance);
        double delta = longitude - Math.toDegrees(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = JSuntimeCalculator.julianDayToJulianCenturies(JSuntimeCalculator.julianCenturiesToJulianDay(t) + timeUTC / 1440.0);
        eqtime = JSuntimeCalculator.equationOfTime(newt);
        solarDec = JSuntimeCalculator.sunDeclination(newt);
        hourangle = JSuntimeCalculator.hourAngleEvening(latitude, solarDec, zenithDistance);
        delta = longitude - Math.toDegrees(hourangle);
        timeDiff = 4.0 * delta;
        double evening = 720.0 + timeDiff - eqtime;
        return evening;
    }

    private static double dateToJulian(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        double extra = 100.0 * (double)year + (double)month - 190002.5;
        double JD = 367.0 * (double)year - Math.floor(7.0 * ((double)year + Math.floor(((double)month + 9.0) / 12.0)) / 4.0) + Math.floor(275.0 * (double)month / 9.0) + (double)day + ((double)hour + ((double)minute + (double)second / 60.0) / 60.0) / 24.0 + 1721013.5 - 0.5 * extra / Math.abs(extra) + 0.5;
        return JD;
    }

    private static double julianDayToJulianCenturies(double julian) {
        return (julian - 2451545.0) / 36525.0;
    }

    private static double julianCenturiesToJulianDay(double t) {
        return t * 36525.0 + 2451545.0;
    }

    private static double equationOfTime(double t) {
        double epsilon = JSuntimeCalculator.obliquityCorrection(t);
        double l0 = JSuntimeCalculator.geomMeanLongSun(t);
        double e = JSuntimeCalculator.eccentricityOfEarthsOrbit(t);
        double m = JSuntimeCalculator.geometricMeanAnomalyOfSun(t);
        double y = Math.pow(Math.tan(Math.toRadians(epsilon) / 2.0), 2.0);
        double eTime = y * Math.sin(2.0 * Math.toRadians(l0)) - 2.0 * e * Math.sin(Math.toRadians(m)) + 4.0 * e * y * Math.sin(Math.toRadians(m)) * Math.cos(2.0 * Math.toRadians(l0)) - 0.5 * y * y * Math.sin(4.0 * Math.toRadians(l0)) - 1.25 * e * e * Math.sin(2.0 * Math.toRadians(m));
        return Math.toDegrees(eTime) * 4.0;
    }

    private static double sunDeclination(double t) {
        double e = JSuntimeCalculator.obliquityCorrection(t);
        double lambda = JSuntimeCalculator.sunsApparentLongitude(t);
        double sint = Math.sin(Math.toRadians(e)) * Math.sin(Math.toRadians(lambda));
        return Math.toDegrees(Math.asin(sint));
    }

    private static double hourAngleMorning(double lat, double solarDec, double zenithDistance) {
        return Math.acos(Math.cos(Math.toRadians(zenithDistance)) / (Math.cos(Math.toRadians(lat)) * Math.cos(Math.toRadians(solarDec))) - Math.tan(Math.toRadians(lat)) * Math.tan(Math.toRadians(solarDec)));
    }

    private static double hourAngleEvening(double lat, double solarDec, double zenithDistance) {
        return -JSuntimeCalculator.hourAngleMorning(lat, solarDec, zenithDistance);
    }

    private static double obliquityCorrection(double t) {
        return JSuntimeCalculator.meanObliquityOfEcliptic(t) + 0.00256 * Math.cos(Math.toRadians(125.04 - 1934.136 * t));
    }

    private static double meanObliquityOfEcliptic(double t) {
        return 23.0 + (26.0 + (21.448 - t * (46.815 + t * (5.9E-4 - t * 0.001813)) / 60.0)) / 60.0;
    }

    private static double geomMeanLongSun(double t) {
        double l0 = 280.46646 + t * (36000.76983 + 3.032E-4 * t);
        while (l0 >= 0.0 && l0 <= 360.0) {
            if (l0 > 360.0) {
                l0 -= 360.0;
            }
            if (!(l0 < 0.0)) continue;
            l0 += 360.0;
        }
        return l0;
    }

    private static double eccentricityOfEarthsOrbit(double t) {
        return 0.016708634 - t * (4.2037E-5 + 1.267E-7 * t);
    }

    private static double geometricMeanAnomalyOfSun(double t) {
        return 357.52911 + t * (35999.05029 - 1.537E-4 * t);
    }

    private static double sunsApparentLongitude(double t) {
        return JSuntimeCalculator.sunsTrueLongitude(t) - 0.00569 - 0.00478 * Math.sin(Math.toRadians(125.04 - 1934.136 * t));
    }

    private static double sunsTrueLongitude(double t) {
        return JSuntimeCalculator.geomMeanLongSun(t) + JSuntimeCalculator.equationOfCentreForSun(t);
    }

    private static double equationOfCentreForSun(double t) {
        double m = JSuntimeCalculator.geometricMeanAnomalyOfSun(t);
        return Math.sin(Math.toRadians(m)) * (1.914602 - t * (0.004817 + 1.4E-5 * t)) + Math.sin(2.0 * Math.toRadians(m)) * (0.019993 - 1.01E-4 * t) + Math.sin(3.0 * Math.toRadians(m)) * 2.89E-4;
    }
}

