/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import net.sourceforge.zmanim.util.GeoLocation;

public class GeoLocationUtils {
    private static int DISTANCE = 0;
    private static int INITIAL_BEARING = 1;
    private static int FINAL_BEARING = 2;

    public static double getGeodesicInitialBearing(GeoLocation location, GeoLocation destination) {
        return GeoLocationUtils.vincentyFormula(location, destination, INITIAL_BEARING);
    }

    public static double getGeodesicFinalBearing(GeoLocation location, GeoLocation destination) {
        return GeoLocationUtils.vincentyFormula(location, destination, FINAL_BEARING);
    }

    public static double getGeodesicDistance(GeoLocation location, GeoLocation destination) {
        return GeoLocationUtils.vincentyFormula(location, destination, DISTANCE);
    }

    private static double vincentyFormula(GeoLocation location, GeoLocation destination, int formula) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double L = Math.toRadians(destination.getLongitude() - location.getLongitude());
        double U1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(location.getLatitude())));
        double U2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(destination.getLatitude())));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double lambdaP = Math.PI * 2;
        double iterLimit = 20.0;
        double sinLambda = 0.0;
        double cosLambda = 0.0;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double sigma = 0.0;
        double sinAlpha = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SigmaM = 0.0;
        while (Math.abs(lambda - lambdaP) > 1.0E-12) {
            double d;
            iterLimit -= 1.0;
            if (!(d > 0.0)) break;
            sinLambda = Math.sin(lambda);
            sinSigma = Math.sqrt(cosU2 * sinLambda * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
            if (sinSigma == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (Double.isNaN(cos2SigmaM)) {
                cos2SigmaM = 0.0;
            }
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            lambdaP = lambda;
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        }
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double distance = b * A * (sigma - deltaSigma);
        double fwdAz = Math.toDegrees(Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
        double revAz = Math.toDegrees(Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda));
        if (formula == DISTANCE) {
            return distance;
        }
        if (formula == INITIAL_BEARING) {
            return fwdAz;
        }
        if (formula == FINAL_BEARING) {
            return revAz;
        }
        return Double.NaN;
    }

    public static double getRhumbLineBearing(GeoLocation location, GeoLocation destination) {
        double dLon = Math.toRadians(destination.getLongitude() - location.getLongitude());
        double dPhi = Math.log(Math.tan(Math.toRadians(destination.getLatitude()) / 2.0 + 0.7853981633974483) / Math.tan(Math.toRadians(location.getLatitude()) / 2.0 + 0.7853981633974483));
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        return Math.toDegrees(Math.atan2(dLon, dPhi));
    }

    public static double getRhumbLineDistance(GeoLocation location, GeoLocation destination) {
        double q;
        double R = 6371.0;
        double dLat = Math.toRadians(destination.getLatitude() - location.getLatitude());
        double dLon = Math.toRadians(Math.abs(destination.getLongitude() - location.getLongitude()));
        double dPhi = Math.log(Math.tan(Math.toRadians(destination.getLongitude()) / 2.0 + 0.7853981633974483) / Math.tan(Math.toRadians(location.getLatitude()) / 2.0 + 0.7853981633974483));
        double d = q = Math.abs(dLat) > 1.0E-10 ? dLat / dPhi : Math.cos(Math.toRadians(location.getLatitude()));
        if (dLon > Math.PI) {
            dLon = Math.PI * 2 - dLon;
        }
        double d2 = Math.sqrt(dLat * dLat + q * q * dLon * dLon);
        return d2 * R;
    }
}

