/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import java.util.TimeZone;

public class GeoLocation
implements Cloneable {
    private double latitude;
    private double longitude;
    private String locationName;
    private TimeZone timeZone;
    private double elevation;
    private int DISTANCE = 0;
    private int INITIAL_BEARING = 1;
    private int FINAL_BEARING = 2;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        if (elevation < 0.0) {
            throw new IllegalArgumentException("Elevation cannot be negative");
        }
        this.elevation = elevation;
    }

    public GeoLocation(String name, double latitude, double longitude, TimeZone timeZone) {
        this(name, latitude, longitude, 0.0, timeZone);
    }

    public GeoLocation(String name, double latitude, double longitude, double elevation, TimeZone timeZone) {
        this.setLocationName(name);
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setElevation(elevation);
        this.setTimeZone(timeZone);
    }

    public GeoLocation() {
        this.setLocationName("Greenwich, England");
        this.setLongitude(0.0);
        this.setLatitude(51.4772);
        this.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Latitude must be between -90 and  90");
        }
        this.latitude = latitude;
    }

    public void setLatitude(int degrees, int minutes, double seconds, String direction) {
        double tempLat = (double)degrees + ((double)minutes + seconds / 60.0) / 60.0;
        if (tempLat > 90.0 || tempLat < 0.0) {
            throw new IllegalArgumentException("Latitude must be between 0 and  90. Use direction of S instead of negative.");
        }
        if (direction.equals("S")) {
            tempLat *= -1.0;
        } else if (!direction.equals("N")) {
            throw new IllegalArgumentException("Latitude direction must be N or S");
        }
        this.latitude = tempLat;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be between -180 and  180");
        }
        this.longitude = longitude;
    }

    public void setLongitude(int degrees, int minutes, double seconds, String direction) {
        double longTemp = (double)degrees + ((double)minutes + seconds / 60.0) / 60.0;
        if (longTemp > 180.0 || this.longitude < 0.0) {
            throw new IllegalArgumentException("Longitude must be between 0 and  180. Use the ");
        }
        if (direction.equals("W")) {
            longTemp *= -1.0;
        } else if (!direction.equals("E")) {
            throw new IllegalArgumentException("Longitude direction must be E or W");
        }
        this.longitude = longTemp;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String name) {
        this.locationName = name;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public long getLocalMeanTimeOffset() {
        return (long)(this.getLongitude() * 4.0 * 60000.0 - (double)this.getTimeZone().getRawOffset());
    }

    public double getGeodesicInitialBearing(GeoLocation location) {
        return this.vincentyFormula(location, this.INITIAL_BEARING);
    }

    public double getGeodesicFinalBearing(GeoLocation location) {
        return this.vincentyFormula(location, this.FINAL_BEARING);
    }

    public double getGeodesicDistance(GeoLocation location) {
        return this.vincentyFormula(location, this.DISTANCE);
    }

    private double vincentyFormula(GeoLocation location, int formula) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double L = Math.toRadians(location.getLongitude() - this.getLongitude());
        double U1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(this.getLatitude())));
        double U2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(location.getLatitude())));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double lambdaP = Math.PI * 2;
        double iterLimit = 20.0;
        double sinLambda = 0.0;
        double cosLambda = 0.0;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double sigma = 0.0;
        double sinAlpha = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SigmaM = 0.0;
        while (Math.abs(lambda - lambdaP) > 1.0E-12) {
            double d;
            iterLimit -= 1.0;
            if (!(d > 0.0)) break;
            sinLambda = Math.sin(lambda);
            sinSigma = Math.sqrt(cosU2 * sinLambda * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
            if (sinSigma == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (Double.isNaN(cos2SigmaM)) {
                cos2SigmaM = 0.0;
            }
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            lambdaP = lambda;
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        }
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double distance = b * A * (sigma - deltaSigma);
        double fwdAz = Math.toDegrees(Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
        double revAz = Math.toDegrees(Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda));
        if (formula == this.DISTANCE) {
            return distance;
        }
        if (formula == this.INITIAL_BEARING) {
            return fwdAz;
        }
        if (formula == this.FINAL_BEARING) {
            return revAz;
        }
        return Double.NaN;
    }

    public double getRhumbLineBearing(GeoLocation location) {
        double dLon = Math.toRadians(location.getLongitude() - this.getLongitude());
        double dPhi = Math.log(Math.tan(Math.toRadians(location.getLatitude()) / 2.0 + 0.7853981633974483) / Math.tan(Math.toRadians(this.getLatitude()) / 2.0 + 0.7853981633974483));
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        return Math.toDegrees(Math.atan2(dLon, dPhi));
    }

    public double getRhumbLineDistance(GeoLocation location) {
        double q;
        double R = 6371.0;
        double dLat = Math.toRadians(location.getLatitude() - this.getLatitude());
        double dLon = Math.toRadians(Math.abs(location.getLongitude() - this.getLongitude()));
        double dPhi = Math.log(Math.tan(Math.toRadians(location.getLongitude()) / 2.0 + 0.7853981633974483) / Math.tan(Math.toRadians(this.getLatitude()) / 2.0 + 0.7853981633974483));
        double d = q = Math.abs(dLat) > 1.0E-10 ? dLat / dPhi : Math.cos(Math.toRadians(this.getLatitude()));
        if (dLon > Math.PI) {
            dLon = Math.PI * 2 - dLon;
        }
        double d2 = Math.sqrt(dLat * dLat + q * q * dLon * dLon);
        return d2 * R;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<GeoLocation>\n");
        sb.append("\t<LocationName>").append(this.getLocationName()).append("</LocationName>\n");
        sb.append("\t<Latitude>").append(this.getLatitude()).append("&deg;").append("</Latitude>\n");
        sb.append("\t<Longitude>").append(this.getLongitude()).append("&deg;").append("</Longitude>\n");
        sb.append("\t<Elevation>").append(this.getElevation()).append(" Meters").append("</Elevation>\n");
        sb.append("\t<TimezoneName>").append(this.getTimeZone().getID()).append("</TimezoneName>\n");
        sb.append("\t<TimeZoneDisplayName>").append(this.getTimeZone().getDisplayName()).append("</TimeZoneDisplayName>\n");
        sb.append("\t<TimezoneGMTOffset>").append((long)this.getTimeZone().getRawOffset() / 3600000L).append("</TimezoneGMTOffset>\n");
        sb.append("\t<TimezoneDSTOffset>").append((long)this.getTimeZone().getDSTSavings() / 3600000L).append("</TimezoneDSTOffset>\n");
        sb.append("</GeoLocation>");
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeoLocation)) {
            return false;
        }
        GeoLocation geo = (GeoLocation)object;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(geo.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(geo.longitude) && this.elevation == geo.elevation && (this.locationName == null ? geo.locationName == null : this.locationName.equals(geo.locationName)) && (this.timeZone == null ? geo.timeZone == null : this.timeZone.equals(geo.timeZone));
    }

    public int hashCode() {
        int result = 17;
        long latLong = Double.doubleToLongBits(this.latitude);
        long lonLong = Double.doubleToLongBits(this.longitude);
        long elevLong = Double.doubleToLongBits(this.elevation);
        int latInt = (int)(latLong ^ latLong >>> 32);
        int lonInt = (int)(lonLong ^ lonLong >>> 32);
        int elevInt = (int)(elevLong ^ elevLong >>> 32);
        result = 37 * result + this.getClass().hashCode();
        result += 37 * result + latInt;
        result += 37 * result + lonInt;
        result += 37 * result + elevInt;
        result += 37 * result + (this.locationName == null ? 0 : this.locationName.hashCode());
        result += 37 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nLocation Name:\t\t\t").append(this.getLocationName());
        sb.append("\nLatitude:\t\t\t").append(this.getLatitude()).append("&deg;");
        sb.append("\nLongitude:\t\t\t").append(this.getLongitude()).append("&deg;");
        sb.append("\nElevation:\t\t\t").append(this.getElevation()).append(" Meters");
        sb.append("\nTimezone Name:\t\t\t").append(this.getTimeZone().getID());
        sb.append("\nTimezone GMT Offset:\t\t").append((long)this.getTimeZone().getRawOffset() / 3600000L);
        sb.append("\nTimezone DST Offset:\t\t").append((long)this.getTimeZone().getDSTSavings() / 3600000L);
        return sb.toString();
    }

    public Object clone() {
        GeoLocation clone = null;
        try {
            clone = (GeoLocation)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.out.print("Required by the compiler. Should never be reached since we implement clone()");
        }
        clone.timeZone = (TimeZone)this.getTimeZone().clone();
        clone.locationName = this.getLocationName();
        return clone;
    }
}

