/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim.util;

import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.SunTimesCalculator;

public abstract class AstronomicalCalculator
implements Cloneable {
    private double refraction = 0.5666666666666667;
    private double solarRadius = 0.26666666666666666;

    public static AstronomicalCalculator getDefault() {
        return new SunTimesCalculator();
    }

    public abstract String getCalculatorName();

    public abstract double getUTCSunrise(AstronomicalCalendar var1, double var2, boolean var4);

    public abstract double getUTCSunset(AstronomicalCalendar var1, double var2, boolean var4);

    double getElevationAdjustment(double elevation) {
        double earthRadius = 6356.9;
        double elevationAdjustment = Math.toDegrees(Math.acos(earthRadius / (earthRadius + elevation / 1000.0)));
        return elevationAdjustment;
    }

    double adjustZenith(double zenith, double elevation) {
        if (zenith == 90.0) {
            zenith += this.getSolarRadius() + this.getRefraction() + this.getElevationAdjustment(elevation);
        }
        return zenith;
    }

    double getRefraction() {
        return this.refraction;
    }

    public void setRefraction(double refraction) {
        this.refraction = refraction;
    }

    double getSolarRadius() {
        return this.solarRadius;
    }

    public void setSolarRadius(double solarRadius) {
        this.solarRadius = solarRadius;
    }

    public Object clone() {
        AstronomicalCalculator clone = null;
        try {
            clone = (AstronomicalCalculator)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.out.print("Required by the compiler. Should never be reached since we implement clone()");
        }
        return clone;
    }
}

