/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim;

import java.util.Date;
import net.sourceforge.zmanim.AstronomicalCalendar;
import net.sourceforge.zmanim.util.GeoLocation;

public class ZmanimCalendar
extends AstronomicalCalendar {
    private static final long serialVersionUID = 1L;
    protected static final double ZENITH_16_POINT_1 = 106.1;
    protected static final double ZENITH_8_POINT_5 = 98.5;
    private double candleLightingOffset = 18.0;

    public Date getTzais() {
        return this.getSunsetOffsetByDegrees(98.5);
    }

    public Date getAlosHashachar() {
        return this.getSunriseOffsetByDegrees(106.1);
    }

    public Date getAlos72() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), -4320000L);
    }

    public Date getChatzos() {
        return this.getSunTransit();
    }

    public Date getSolarMidnight() {
        ZmanimCalendar clonedCal = (ZmanimCalendar)this.clone();
        clonedCal.getCalendar().add(5, 1);
        Date sunset = this.getSunset();
        Date sunrise = clonedCal.getSunrise();
        return this.getTimeOffset(sunset, this.getTemporalHour(sunset, sunrise) * 6L);
    }

    public Date getSofZmanShmaGRA() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), this.getShaahZmanisGra() * 3L);
    }

    public Date getSofZmanShmaMGA() {
        return this.getTimeOffset(this.getAlos72(), this.getShaahZmanisMGA() * 3L);
    }

    public Date getTzais72() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 4320000L);
    }

    public Date getCandelLighting() {
        return this.getTimeOffset(this.getSunset(), -this.getCandleLightingOffset() * 60000.0);
    }

    public Date getSofZmanTfilaGRA() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), this.getShaahZmanisGra() * 4L);
    }

    public Date getSofZmanTfilaMGA() {
        return this.getTimeOffset(this.getAlos72(), this.getShaahZmanisMGA() * 4L);
    }

    public Date getMinchaGedola() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), (double)this.getShaahZmanisGra() * 6.5);
    }

    public Date getMinchaKetana() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), (double)this.getShaahZmanisGra() * 9.5);
    }

    public Date getPlagHamincha() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), (double)this.getShaahZmanisGra() * 10.75);
    }

    public long getShaahZmanisGra() {
        return this.getTemporalHour(this.getSeaLevelSunrise(), this.getSeaLevelSunset());
    }

    public long getShaahZmanisMGA() {
        return this.getTemporalHour(this.getAlos72(), this.getTzais72());
    }

    public ZmanimCalendar() {
    }

    public ZmanimCalendar(GeoLocation location) {
        super(location);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZmanimCalendar)) {
            return false;
        }
        ZmanimCalendar zCal = (ZmanimCalendar)object;
        return this.getCalendar().equals(zCal.getCalendar()) && this.getGeoLocation().equals(zCal.getGeoLocation()) && this.getAstronomicalCalculator().equals(zCal.getAstronomicalCalculator());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result += 37 * result + this.getCalendar().hashCode();
        result += 37 * result + this.getGeoLocation().hashCode();
        result += 37 * result + this.getAstronomicalCalculator().hashCode();
        return result;
    }

    public double getCandleLightingOffset() {
        return this.candleLightingOffset;
    }

    public void setCandleLightingOffset(double candleLightingOffset) {
        this.candleLightingOffset = candleLightingOffset;
    }
}

