/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim;

import java.util.Date;
import net.sourceforge.zmanim.ZmanimCalendar;
import net.sourceforge.zmanim.util.GeoLocation;

public class ComplexZmanimCalendar
extends ZmanimCalendar {
    private static final long serialVersionUID = 1L;
    protected static final double ZENITH_3_POINT_7 = 93.7;
    protected static final double ZENITH_5_POINT_95 = 95.95;
    protected static final double ZENITH_7_POINT_083 = 97.0;
    protected static final double ZENITH_10_POINT_2 = 100.2;
    protected static final double ZENITH_11_DEGREES = 101.0;
    protected static final double ZENITH_11_POINT_5 = 101.5;
    protected static final double ZENITH_13_DEGREES = 103.0;
    protected static final double ZENITH_19_POINT_8 = 109.8;
    protected static final double ZENITH_26_DEGREES = 116.0;
    protected static final double ZENITH_4_POINT_37 = 94.37;
    protected static final double ZENITH_4_POINT_61 = 94.61;
    protected static final double ZENITH_4_POINT_8 = 94.8;
    protected static final double ZENITH_3_POINT_65 = 93.65;
    protected static final double ZENITH_5_POINT_88 = 95.88;
    private double ateretTorahSunsetOffset = 40.0;

    public ComplexZmanimCalendar(GeoLocation location) {
        super(location);
    }

    public ComplexZmanimCalendar() {
    }

    public long getShaahZmanis19Point8Degrees() {
        return this.getTemporalHour(this.getAlos19Point8Degrees(), this.getTzais19Point8Degrees());
    }

    public long getShaahZmanis18Degrees() {
        return this.getTemporalHour(this.getAlos18Degrees(), this.getTzais18Degrees());
    }

    public long getShaahZmanis26Degrees() {
        return this.getTemporalHour(this.getAlos26Degrees(), this.getTzais26Degrees());
    }

    public long getShaahZmanis16Point1Degrees() {
        return this.getTemporalHour(this.getAlos16Point1Degrees(), this.getTzais16Point1Degrees());
    }

    public long getShaahZmanis60Minutes() {
        return this.getTemporalHour(this.getAlos60(), this.getTzais60());
    }

    public long getShaahZmanis72Minutes() {
        return this.getShaahZmanisMGA();
    }

    public long getShaahZmanis72MinutesZmanis() {
        return this.getTemporalHour(this.getAlos72Zmanis(), this.getTzais72Zmanis());
    }

    public long getShaahZmanis90Minutes() {
        return this.getTemporalHour(this.getAlos90(), this.getTzais90());
    }

    public long getShaahZmanis90MinutesZmanis() {
        return this.getTemporalHour(this.getAlos90Zmanis(), this.getTzais90Zmanis());
    }

    public long getShaahZmanis96MinutesZmanis() {
        return this.getTemporalHour(this.getAlos96Zmanis(), this.getTzais96Zmanis());
    }

    public long getShaahZmanisAteretTorah() {
        return this.getTemporalHour(this.getAlos72Zmanis(), this.getTzaisAteretTorah());
    }

    public long getShaahZmanis96Minutes() {
        return this.getTemporalHour(this.getAlos96(), this.getTzais96());
    }

    public long getShaahZmanis120Minutes() {
        return this.getTemporalHour(this.getAlos120(), this.getTzais120());
    }

    public long getShaahZmanis120MinutesZmanis() {
        return this.getTemporalHour(this.getAlos120Zmanis(), this.getTzais120Zmanis());
    }

    public Date getPlagHamincha120MinutesZmanis() {
        return this.getTimeOffset(this.getAlos120Zmanis(), (double)this.getShaahZmanis120MinutesZmanis() * 10.75);
    }

    public Date getPlagHamincha120Minutes() {
        return this.getTimeOffset(this.getAlos120(), (double)this.getShaahZmanis120Minutes() * 10.75);
    }

    public Date getAlos60() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), -3600000L);
    }

    public Date getAlos72Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunrise(), (long)((double)shaahZmanis * -1.2));
    }

    public Date getAlos96() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), -5760000L);
    }

    public Date getAlos90Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunrise(), (long)((double)shaahZmanis * -1.5));
    }

    public Date getAlos96Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunrise(), (long)((double)shaahZmanis * -1.6));
    }

    public Date getAlos90() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), -5400000L);
    }

    public Date getAlos120() {
        return this.getTimeOffset(this.getSeaLevelSunrise(), -7200000L);
    }

    public Date getAlos120Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunrise(), shaahZmanis * -2L);
    }

    public Date getAlos26Degrees() {
        return this.getSunriseOffsetByDegrees(116.0);
    }

    public Date getAlos18Degrees() {
        return this.getSunriseOffsetByDegrees(108.0);
    }

    public Date getAlos19Point8Degrees() {
        return this.getSunriseOffsetByDegrees(109.8);
    }

    public Date getAlos16Point1Degrees() {
        return this.getSunriseOffsetByDegrees(106.1);
    }

    public Date getMisheyakir11Point5Degrees() {
        return this.getSunriseOffsetByDegrees(101.5);
    }

    public Date getMisheyakir11Degrees() {
        return this.getSunriseOffsetByDegrees(101.0);
    }

    public Date getMisheyakir10Point2Degrees() {
        return this.getSunriseOffsetByDegrees(100.2);
    }

    public Date getSofZmanShmaMGA19Point8Degrees() {
        return this.getTimeOffset(this.getAlos19Point8Degrees(), this.getShaahZmanis19Point8Degrees() * 3L);
    }

    public Date getSofZmanShmaMGA16Point1Degrees() {
        return this.getTimeOffset(this.getAlos16Point1Degrees(), this.getShaahZmanis16Point1Degrees() * 3L);
    }

    public Date getSofZmanShmaMGA72Minutes() {
        return this.getSofZmanShmaMGA();
    }

    public Date getSofZmanShmaMGA72MinutesZmanis() {
        return this.getTimeOffset(this.getAlos72Zmanis(), this.getShaahZmanis72MinutesZmanis() * 3L);
    }

    public Date getSofZmanShmaMGA90Minutes() {
        return this.getTimeOffset(this.getAlos90(), this.getShaahZmanis90Minutes() * 3L);
    }

    public Date getSofZmanShmaMGA90MinutesZmanis() {
        return this.getTimeOffset(this.getAlos90Zmanis(), this.getShaahZmanis90MinutesZmanis() * 3L);
    }

    public Date getSofZmanShmaMGA96Minutes() {
        return this.getTimeOffset(this.getAlos96(), this.getShaahZmanis96Minutes() * 3L);
    }

    public Date getSofZmanShmaMGA96MinutesZmanis() {
        return this.getTimeOffset(this.getAlos96Zmanis(), this.getShaahZmanis96MinutesZmanis() * 3L);
    }

    public Date getSofZmanShma3HoursBeforeChatzos() {
        return this.getTimeOffset(this.getChatzos(), -10800000L);
    }

    public Date getSofZmanShmaMGA120Minutes() {
        return this.getTimeOffset(this.getAlos120(), this.getShaahZmanis120Minutes() * 3L);
    }

    public Date getSofZmanShmaAlos16Point1ToSunset() {
        long shaahZmanis = this.getTemporalHour(this.getAlos16Point1Degrees(), this.getSeaLevelSunset());
        return this.getTimeOffset(this.getAlos16Point1Degrees(), shaahZmanis * 3L);
    }

    public Date getSofZmanShmaAlos16Point1ToTzaisGeonim7Point083Degrees() {
        long shaahZmanis = this.getTemporalHour(this.getAlos16Point1Degrees(), this.getTzaisGeonim7Point083Degrees());
        return this.getTimeOffset(this.getAlos16Point1Degrees(), shaahZmanis * 3L);
    }

    public Date getSofZmanShmaKolEliyahu() {
        Date chatzos = this.getFixedLocalChatzos();
        if (chatzos == null || this.getSunrise() == null) {
            return null;
        }
        long diff = (chatzos.getTime() - this.getSeaLevelSunrise().getTime()) / 2L;
        return this.getTimeOffset(chatzos, -diff);
    }

    public Date getSofZmanTfilaMGA19Point8Degrees() {
        return this.getTimeOffset(this.getAlos19Point8Degrees(), this.getShaahZmanis19Point8Degrees() * 4L);
    }

    public Date getSofZmanTfilaMGA16Point1Degrees() {
        return this.getTimeOffset(this.getAlos16Point1Degrees(), this.getShaahZmanis16Point1Degrees() * 4L);
    }

    public Date getSofZmanTfilaMGA72Minutes() {
        return this.getSofZmanTfilaMGA();
    }

    public Date getSofZmanTfilaMGA72MinutesZmanis() {
        return this.getTimeOffset(this.getAlos72Zmanis(), this.getShaahZmanis72MinutesZmanis() * 4L);
    }

    public Date getSofZmanTfilaMGA90Minutes() {
        return this.getTimeOffset(this.getAlos90(), this.getShaahZmanis90Minutes() * 4L);
    }

    public Date getSofZmanTfilaMGA90MinutesZmanis() {
        return this.getTimeOffset(this.getAlos90Zmanis(), this.getShaahZmanis90MinutesZmanis() * 4L);
    }

    public Date getSofZmanTfilaMGA96Minutes() {
        return this.getTimeOffset(this.getAlos96(), this.getShaahZmanis96Minutes() * 4L);
    }

    public Date getSofZmanTfilaMGA96MinutesZmanis() {
        return this.getTimeOffset(this.getAlos96Zmanis(), this.getShaahZmanis96MinutesZmanis() * 4L);
    }

    public Date getSofZmanTfilaMGA120Minutes() {
        return this.getTimeOffset(this.getAlos120(), this.getShaahZmanis120Minutes() * 4L);
    }

    public Date getSofZmanTfila2HoursBeforeChatzos() {
        return this.getTimeOffset(this.getChatzos(), -7200000L);
    }

    public Date getMinchaGedola30Minutes() {
        return this.getTimeOffset(this.getChatzos(), 1800000L);
    }

    public Date getMinchaGedola72Minutes() {
        return this.getTimeOffset(this.getAlos72(), (double)this.getShaahZmanis72Minutes() * 6.5);
    }

    public Date getMinchaGedola16Point1Degrees() {
        return this.getTimeOffset(this.getAlos16Point1Degrees(), (double)this.getShaahZmanis16Point1Degrees() * 6.5);
    }

    public Date getMinchaGedolaGreaterThan30() {
        if (this.getMinchaGedola30Minutes() == null || this.getMinchaGedola() == null) {
            return null;
        }
        return this.getMinchaGedola30Minutes().compareTo(this.getMinchaGedola()) > 0 ? this.getMinchaGedola30Minutes() : this.getMinchaGedola();
    }

    public Date getMinchaKetana16Point1Degrees() {
        return this.getTimeOffset(this.getAlos16Point1Degrees(), (double)this.getShaahZmanis16Point1Degrees() * 9.5);
    }

    public Date getMinchaKetana72Minutes() {
        return this.getTimeOffset(this.getAlos72(), (double)this.getShaahZmanis72Minutes() * 9.5);
    }

    public Date getPlagHamincha60Minutes() {
        return this.getTimeOffset(this.getAlos60(), (double)this.getShaahZmanis60Minutes() * 10.75);
    }

    public Date getPlagHamincha72Minutes() {
        return this.getTimeOffset(this.getAlos72(), (double)this.getShaahZmanis72Minutes() * 10.75);
    }

    public Date getPlagHamincha90Minutes() {
        return this.getTimeOffset(this.getAlos90(), (double)this.getShaahZmanis90Minutes() * 10.75);
    }

    public Date getPlagHamincha96Minutes() {
        return this.getTimeOffset(this.getAlos96(), (double)this.getShaahZmanis96Minutes() * 10.75);
    }

    public Date getPlagHamincha96MinutesZmanis() {
        return this.getTimeOffset(this.getAlos96Zmanis(), (double)this.getShaahZmanis96MinutesZmanis() * 10.75);
    }

    public Date getPlagHamincha90MinutesZmanis() {
        return this.getTimeOffset(this.getAlos90Zmanis(), (double)this.getShaahZmanis90MinutesZmanis() * 10.75);
    }

    public Date getPlagHamincha72MinutesZmanis() {
        return this.getTimeOffset(this.getAlos72Zmanis(), (double)this.getShaahZmanis72MinutesZmanis() * 10.75);
    }

    public Date getPlagHamincha16Point1Degrees() {
        return this.getTimeOffset(this.getAlos16Point1Degrees(), (double)this.getShaahZmanis16Point1Degrees() * 10.75);
    }

    public Date getPlagHamincha19Point8Degrees() {
        return this.getTimeOffset(this.getAlos19Point8Degrees(), (double)this.getShaahZmanis19Point8Degrees() * 10.75);
    }

    public Date getPlagHamincha26Degrees() {
        return this.getTimeOffset(this.getAlos26Degrees(), (double)this.getShaahZmanis26Degrees() * 10.75);
    }

    public Date getPlagHamincha18Degrees() {
        return this.getTimeOffset(this.getAlos18Degrees(), (double)this.getShaahZmanis18Degrees() * 10.75);
    }

    public Date getPlagAlosToSunset() {
        long shaahZmanis = this.getTemporalHour(this.getAlos16Point1Degrees(), this.getSeaLevelSunset());
        return this.getTimeOffset(this.getAlos16Point1Degrees(), (double)shaahZmanis * 10.75);
    }

    public Date getPlagAlos16Point1ToTzaisGeonim7Point083Degrees() {
        long shaahZmanis = this.getTemporalHour(this.getAlos16Point1Degrees(), this.getTzaisGeonim7Point083Degrees());
        return this.getTimeOffset(this.getAlos16Point1Degrees(), (double)shaahZmanis * 10.75);
    }

    public Date getBainHasmashosRT13Degrees() {
        return this.getSunsetOffsetByDegrees(103.0);
    }

    public Date getBainHasmashosRT58Point5Minutes() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 3510000.0);
    }

    public Date getBainHasmashosRT13Point5MinutesBefore7Point083Degrees() {
        return this.getTimeOffset(this.getSunsetOffsetByDegrees(97.0), -810000.0);
    }

    public Date getBainHasmashosRT2Stars() {
        Date alos19Point8 = this.getAlos19Point8Degrees();
        Date sunrise = this.getSeaLevelSunrise();
        if (alos19Point8 == null || sunrise == null) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunset(), (double)(sunrise.getTime() - alos19Point8.getTime()) * 0.2777777777777778);
    }

    public Date getTzaisGeonim5Point95Degrees() {
        return this.getSunsetOffsetByDegrees(95.95);
    }

    public Date getTzaisGeonim3Point65Degrees() {
        return this.getSunsetOffsetByDegrees(93.65);
    }

    public Date getTzaisGeonim4Point61Degrees() {
        return this.getSunsetOffsetByDegrees(94.61);
    }

    public Date getTzaisGeonim4Point37Degrees() {
        return this.getSunsetOffsetByDegrees(94.37);
    }

    public Date getTzaisGeonim5Point88Degrees() {
        return this.getSunsetOffsetByDegrees(95.88);
    }

    public Date getTzaisGeonim4Point8Degrees() {
        return this.getSunsetOffsetByDegrees(94.8);
    }

    public Date getTzaisGeonim7Point083Degrees() {
        return this.getSunsetOffsetByDegrees(97.0);
    }

    public Date getTzaisGeonim8Point5Degrees() {
        return this.getSunsetOffsetByDegrees(98.5);
    }

    public Date getTzais60() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 3600000L);
    }

    public Date getTzaisAteretTorah() {
        return this.getTimeOffset(this.getSeaLevelSunset(), this.getAteretTorahSunsetOffset() * 60000.0);
    }

    public double getAteretTorahSunsetOffset() {
        return this.ateretTorahSunsetOffset;
    }

    public void setAteretTorahSunsetOffset(double ateretTorahSunsetOffset) {
        this.ateretTorahSunsetOffset = ateretTorahSunsetOffset;
    }

    public Date getSofZmanShmaAteretTorah() {
        return this.getTimeOffset(this.getAlos72Zmanis(), this.getShaahZmanisAteretTorah() * 3L);
    }

    public Date getSofZmanTfilahAteretTorah() {
        return this.getTimeOffset(this.getAlos72Zmanis(), this.getShaahZmanisAteretTorah() * 4L);
    }

    public Date getMinchaGedolaAteretTorah() {
        return this.getTimeOffset(this.getAlos72Zmanis(), (double)this.getShaahZmanisAteretTorah() * 6.5);
    }

    public Date getMinchaKetanaAteretTorah() {
        return this.getTimeOffset(this.getAlos72Zmanis(), (double)this.getShaahZmanisAteretTorah() * 9.5);
    }

    public Date getPlagHaminchaAteretTorah() {
        return this.getTimeOffset(this.getAlos72Zmanis(), (double)this.getShaahZmanisAteretTorah() * 10.75);
    }

    public Date getTzais72Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunset(), (double)shaahZmanis * 1.2);
    }

    public Date getTzais90Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunset(), (double)shaahZmanis * 1.5);
    }

    public Date getTzais96Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunset(), (double)shaahZmanis * 1.6);
    }

    public Date getTzais90() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 5400000L);
    }

    public Date getTzais120() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 0x6DDD00L);
    }

    public Date getTzais120Zmanis() {
        long shaahZmanis = this.getShaahZmanisGra();
        if (shaahZmanis == Long.MIN_VALUE) {
            return null;
        }
        return this.getTimeOffset(this.getSeaLevelSunset(), (double)shaahZmanis * 2.0);
    }

    public Date getTzais16Point1Degrees() {
        return this.getSunsetOffsetByDegrees(106.1);
    }

    public Date getTzais26Degrees() {
        return this.getSunsetOffsetByDegrees(116.0);
    }

    public Date getTzais18Degrees() {
        return this.getSunsetOffsetByDegrees(108.0);
    }

    public Date getTzais19Point8Degrees() {
        return this.getSunsetOffsetByDegrees(109.8);
    }

    public Date getTzais96() {
        return this.getTimeOffset(this.getSeaLevelSunset(), 5760000L);
    }

    public Date getFixedLocalChatzos() {
        return this.getTimeOffset(this.getDateFromTime(12.0 - (double)((long)this.getGeoLocation().getTimeZone().getRawOffset() / 3600000L)), -this.getGeoLocation().getLocalMeanTimeOffset());
    }

    public Date getSofZmanShmaFixedLocal() {
        return this.getTimeOffset(this.getFixedLocalChatzos(), -10800000L);
    }

    public Date getSofZmanTfilaFixedLocal() {
        return this.getTimeOffset(this.getFixedLocalChatzos(), -7200000L);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ComplexZmanimCalendar)) {
            return false;
        }
        ComplexZmanimCalendar cCal = (ComplexZmanimCalendar)object;
        return this.getCalendar().equals(cCal.getCalendar()) && this.getGeoLocation().equals(cCal.getGeoLocation()) && this.getAstronomicalCalculator().equals(cCal.getAstronomicalCalculator());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result += 37 * result + this.getCalendar().hashCode();
        result += 37 * result + this.getGeoLocation().hashCode();
        result += 37 * result + this.getAstronomicalCalculator().hashCode();
        return result;
    }
}

