/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zmanim;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.zmanim.util.AstronomicalCalculator;
import net.sourceforge.zmanim.util.GeoLocation;
import net.sourceforge.zmanim.util.ZmanimFormatter;

public class AstronomicalCalendar
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final double GEOMETRIC_ZENITH = 90.0;
    public static final double CIVIL_ZENITH = 96.0;
    public static final double NAUTICAL_ZENITH = 102.0;
    public static final double ASTRONOMICAL_ZENITH = 108.0;
    static final long MINUTE_MILLIS = 60000L;
    static final long HOUR_MILLIS = 3600000L;
    private Calendar calendar;
    private GeoLocation geoLocation;
    private AstronomicalCalculator astronomicalCalculator;

    public Date getSunrise() {
        double sunrise = this.getUTCSunrise(90.0);
        if (Double.isNaN(sunrise)) {
            return null;
        }
        return this.getDateFromTime(sunrise);
    }

    public Date getSeaLevelSunrise() {
        double sunrise = this.getUTCSeaLevelSunrise(90.0);
        if (Double.isNaN(sunrise)) {
            return null;
        }
        return this.getDateFromTime(sunrise);
    }

    public Date getBeginCivilTwilight() {
        return this.getSunriseOffsetByDegrees(96.0);
    }

    public Date getBeginNauticalTwilight() {
        return this.getSunriseOffsetByDegrees(102.0);
    }

    public Date getBeginAstronomicalTwilight() {
        return this.getSunriseOffsetByDegrees(108.0);
    }

    public Date getSunset() {
        double sunset = this.getUTCSunset(90.0);
        if (Double.isNaN(sunset)) {
            return null;
        }
        return this.getAdjustedSunsetDate(this.getDateFromTime(sunset), this.getSunrise());
    }

    private Date getAdjustedSunsetDate(Date sunset, Date sunrise) {
        if (sunset != null && sunrise != null && sunrise.compareTo(sunset) >= 0) {
            Calendar clonedCalendar = (Calendar)this.getCalendar().clone();
            clonedCalendar.setTime(sunset);
            clonedCalendar.add(5, 1);
            return clonedCalendar.getTime();
        }
        return sunset;
    }

    public Date getSeaLevelSunset() {
        double sunset = this.getUTCSeaLevelSunset(90.0);
        if (Double.isNaN(sunset)) {
            return null;
        }
        return this.getAdjustedSunsetDate(this.getDateFromTime(sunset), this.getSeaLevelSunrise());
    }

    public Date getEndCivilTwilight() {
        return this.getSunsetOffsetByDegrees(96.0);
    }

    public Date getEndNauticalTwilight() {
        return this.getSunsetOffsetByDegrees(102.0);
    }

    public Date getEndAstronomicalTwilight() {
        return this.getSunsetOffsetByDegrees(108.0);
    }

    public Date getTimeOffset(Date time, double offset) {
        return this.getTimeOffset(time, (long)offset);
    }

    public Date getTimeOffset(Date time, long offset) {
        if (time == null || offset == Long.MIN_VALUE) {
            return null;
        }
        return new Date(time.getTime() + offset);
    }

    public Date getSunriseOffsetByDegrees(double offsetZenith) {
        double alos = this.getUTCSunrise(offsetZenith);
        if (Double.isNaN(alos)) {
            return null;
        }
        return this.getDateFromTime(alos);
    }

    public Date getSunsetOffsetByDegrees(double offsetZenith) {
        double sunset = this.getUTCSunset(offsetZenith);
        if (Double.isNaN(sunset)) {
            return null;
        }
        return this.getAdjustedSunsetDate(this.getDateFromTime(sunset), this.getSunriseOffsetByDegrees(offsetZenith));
    }

    public AstronomicalCalendar() {
        this(new GeoLocation());
    }

    public AstronomicalCalendar(GeoLocation geoLocation) {
        this.setCalendar(Calendar.getInstance(geoLocation.getTimeZone()));
        this.setGeoLocation(geoLocation);
        this.setAstronomicalCalculator(AstronomicalCalculator.getDefault());
    }

    public double getUTCSunrise(double zenith) {
        return this.getAstronomicalCalculator().getUTCSunrise(this, zenith, true);
    }

    public double getUTCSeaLevelSunrise(double zenith) {
        return this.getAstronomicalCalculator().getUTCSunrise(this, zenith, false);
    }

    public double getUTCSunset(double zenith) {
        return this.getAstronomicalCalculator().getUTCSunset(this, zenith, true);
    }

    public double getUTCSeaLevelSunset(double zenith) {
        return this.getAstronomicalCalculator().getUTCSunset(this, zenith, false);
    }

    private double getOffsetTime(double time) {
        boolean dst = this.getCalendar().getTimeZone().inDaylightTime(this.getCalendar().getTime());
        double dstOffset = 0.0;
        double gmtOffset = (long)this.getCalendar().getTimeZone().getRawOffset() / 3600000L;
        if (dst) {
            dstOffset = (long)this.getCalendar().getTimeZone().getDSTSavings() / 3600000L;
        }
        return time + gmtOffset + dstOffset;
    }

    public long getTemporalHour() {
        return this.getTemporalHour(this.getSunrise(), this.getSunset());
    }

    public long getTemporalHour(Date sunrise, Date sunset) {
        if (sunrise == null || sunset == null) {
            return Long.MIN_VALUE;
        }
        return (sunset.getTime() - sunrise.getTime()) / 12L;
    }

    public Date getSunTransit() {
        return this.getTimeOffset(this.getSunrise(), this.getTemporalHour() * 6L);
    }

    protected Date getDateFromTime(double time) {
        if (Double.isNaN(time)) {
            return null;
        }
        time = this.getOffsetTime(time);
        time = (time + 240.0) % 24.0;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, this.getCalendar().get(1));
        cal.set(2, this.getCalendar().get(2));
        cal.set(5, this.getCalendar().get(5));
        int hours = (int)time;
        time -= (double)hours;
        int minutes = (int)(time *= 60.0);
        time -= (double)minutes;
        int seconds = (int)(time *= 60.0);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, (int)((time -= (double)seconds) * 1000.0));
        return cal.getTime();
    }

    public double getSunriseSolarDipFromOffset(double minutes) {
        Date offsetByDegrees = this.getSeaLevelSunrise();
        Date offsetByTime = this.getTimeOffset(this.getSeaLevelSunrise(), -(minutes * 60000.0));
        BigDecimal degrees = new BigDecimal(0);
        BigDecimal incrementor = new BigDecimal("0.0001");
        while (offsetByDegrees == null || offsetByDegrees.getTime() > offsetByTime.getTime()) {
            degrees = degrees.add(incrementor);
            offsetByDegrees = this.getSunriseOffsetByDegrees(90.0 + degrees.doubleValue());
        }
        return degrees.doubleValue();
    }

    public double getSunsetSolarDipFromOffset(double minutes) {
        Date offsetByDegrees = this.getSeaLevelSunset();
        Date offsetByTime = this.getTimeOffset(this.getSeaLevelSunset(), minutes * 60000.0);
        BigDecimal degrees = new BigDecimal(0);
        BigDecimal incrementor = new BigDecimal("0.0001");
        while (offsetByDegrees == null || offsetByDegrees.getTime() < offsetByTime.getTime()) {
            degrees = degrees.add(incrementor);
            offsetByDegrees = this.getSunsetOffsetByDegrees(90.0 + degrees.doubleValue());
        }
        return degrees.doubleValue();
    }

    public String toString() {
        return ZmanimFormatter.toXML(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AstronomicalCalendar)) {
            return false;
        }
        AstronomicalCalendar aCal = (AstronomicalCalendar)object;
        return this.getCalendar().equals(aCal.getCalendar()) && this.getGeoLocation().equals(aCal.getGeoLocation()) && this.getAstronomicalCalculator().equals(aCal.getAstronomicalCalculator());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result += 37 * result + this.getCalendar().hashCode();
        result += 37 * result + this.getGeoLocation().hashCode();
        result += 37 * result + this.getAstronomicalCalculator().hashCode();
        return result;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
        this.getCalendar().setTimeZone(geoLocation.getTimeZone());
    }

    public AstronomicalCalculator getAstronomicalCalculator() {
        return this.astronomicalCalculator;
    }

    public void setAstronomicalCalculator(AstronomicalCalculator astronomicalCalculator) {
        this.astronomicalCalculator = astronomicalCalculator;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (this.getGeoLocation() != null) {
            this.getCalendar().setTimeZone(this.getGeoLocation().getTimeZone());
        }
    }

    public Object clone() {
        AstronomicalCalendar clone = null;
        try {
            clone = (AstronomicalCalendar)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.out.print("Required by the compiler. Should never be reached since we implement clone()");
        }
        clone.setGeoLocation((GeoLocation)this.getGeoLocation().clone());
        clone.setCalendar((Calendar)this.getCalendar().clone());
        clone.setAstronomicalCalculator((AstronomicalCalculator)this.getAstronomicalCalculator().clone());
        return clone;
    }
}

